
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                  Main                                     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#define VARNUM	52 // number of variables a..z, A..Z
#define STACKSIZE 100 // max. stack size

#define INFILE "LongCalc.scr" // input script file

// input file
extern CText Row;			// text of current input file row, without result and without comment
extern bignum Res;			// row result
extern int RowPos;			// position in current input file row

// numbers
extern bint IntRandMin;		// min. number of digits of integer part of random numbers
extern bint DecRandMin;		// min. number of digits of decimal part of random numbers
extern bint IntRand;		// max. number of digits of integer part of random numbers
extern bint DecRand;		// max. number of digits of decimal part of random numbers
extern bignum Var[VARNUM];		// variables a..z, A..Z
extern bignum Stack[STACKSIZE];	// stack of semiresults
extern int StackNum;		// number of numbers in stack

// get random number
u64 Rand();
u32 Rand32();

// random number with limitation
u64 Rand(u64 max);

// random bit string (bits = max. number of bits, returns real number of bits)
int RandBits(void* dst, int bits, bool noneg = false);

// random test number with random number of bits (1..64)
/*u64 RandTest64();

// random test number with random number of bits (1..32)
u32 RandTest32();

// random test number with random number of bits (1..16)
u16 RandTest16();

// random test number with random number of bits (1..8)
u8 RandTest8();
*/

// start performance timer (and start measuring time delta)
void StartTime();

// get time delta in sec
double GetTime();
